<?php

namespace Wolfie\Models;

use Illuminate\Database\Eloquent\Model;

class Ad extends Model 
{

    protected $table = 'ads';
    public $timestamps = true;
    protected $fillable = array('service_id', 'location', 'cords', 'date', 'date_type');
    protected $visible = array('client_id');

    public function client()
    {
        return $this->hasOne('Client', 'client_id');
    }

    public function service()
    {
        return $this->hasOne('Service', 'service_id');
    }

    public function thread()
    {
        return $this->morphOne('Thread', 'threadable')->withPivot();
    }

    public function review()
    {
        return $this->morphOne('Reviews', 'reviewable');
    }

}